#version 330
#extension GL_EXT_gpu_shader4 : enable
// Cloud-free TwisterMod01.fsh by  Blueberry

//https://www.shadertoy.com/view/lllXWH
// Licence CC0
// Adapted, trivialy, for use in VGHD player
/////////////////////////////////////////////
uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels
uniform vec3      iChannelResolution[4];
#define iTime u_Elapsed  //*0.314159  //*0.1666
#define iResolution u_WindowSize

//#define mouse AUTO_MOUSE
//#define MOUSE_SPEED vec2(vec2(0.5,0.577777) * 0.25)
//#define MOUSE_POS   vec2((1.0+cos(iTime*MOUSE_SPEED))*u_WindowSize/2.0)
//#define MOUSE_PRESS vec2(0.0,0.0)
//#define AUTO_MOUSE  vec4( MOUSE_POS, MOUSE_PRESS )
//#define RIGID_SCROLL
// alternatively use static mouse definition
#define iMouse vec4(0.0,0.0, 0.0,0.0)
//#define iMouse vec4(512,256,180,120)
uniform sampler2D iChannel0;
uniform sampler2D iChannel1;
uniform sampler2D iChannel2;
uniform sampler2D iChannel3;
vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture2D(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture2D(sampler,fract(P),Bias);}
#define texture2D texture2D_Fract


#define DIST 60  //40.0
#define FAR 177  //100.0
#define M_PI 3.14159265358979
#define M_2PI (2.0*3.14159265358979)
#define SPEED 7.0
#define STEPSIZE 0.6
#define ITERATIONS 40

// Texture lookup
float tp(int u, int v) {
    vec2 coord = (vec2(u,v) + 0.5) / iChannelResolution[0].xy;
    return texture(iChannel0, coord).r;
}

// Manual bilinear interpolation to get around interpolation accuracy
float itp(vec2 p) {
	ivec2 c = ivec2(floor(p));
    vec2 f = smoothstep(vec2(0),vec2(1),p-floor(p));
    return mix(mix(tp(c.x,c.y),tp(c.x+1,c.y),f.x),mix(tp(c.x,c.y+1),tp(c.x+1,c.y+1),f.x),f.y);
}

// Defines twister shape
float shape(float u, float v) {
    return itp(vec2(u,v));
}

// Shading
vec3 light(vec3 n, vec3 l, vec3 col) {
	l = normalize(l);
	vec3 h = normalize(mix(l, vec3(0,0,1), 0.5));
    vec3 d = max(0.0, dot(n,l)) * col;
    vec3 s = pow(max(0.0, dot(n,h)), 42.0) * col;
    return d + s;
}

// Compute distance to twister
float tv(float r, float s, float d, float c, float k) {
	vec2 p = vec2(DIST,0) - s * vec2(1,d);
    float a = atan(p.y,p.x)*3.0 + r;
	float h = shape(c,a) * 10.0 + (sin(c*2.0)*5.0 + 5.0) * k;
    return length(p) - h;
}
void main (void)
//void mainImage( out vec4 fragColor, in vec2 fragCoord )
{
	float time = iTime;
    vec2 xy = (gl_FragCoord.xy - iResolution.xy / 2.0) / iResolution.y;
    
    // Rotate display
	float gr = time*0.2 + sin(time)*0.5;
	vec2 xyr = mat2(cos(gr),sin(gr),-sin(gr),cos(gr)) * xy;

    // Init twister parameters
    float c = xyr.y*3.0 + time;
    float d = xyr.x;
    float dist0 = DIST;
	float depth = FAR;
    float t = c + time*3.0;
	float r = t + sin(t*0.3)*10.0;

    // Pulse to the beat
	float k = 1.0;
    float kickspacing = 8.0/SPEED;
	float kickindex = floor(time / kickspacing);
    float kicktime = time - kickindex * kickspacing;
    if (fract(kickindex / 32.0) >= 0.5) {
		k = 1.0 + 0.5*sin(kicktime*SPEED*M_PI)*exp(-kicktime*3.0);
    }

    // Accelerate sure misses
    float hmax = 10.0 + (sin(c*2.0)*5.0 + 5.0) * k;
    float closest_s = DIST / (d*d+1.0);
	vec2 closest_p = vec2(DIST,0) - closest_s * vec2(1,d);
	float closest_dist = length(closest_p) - hmax;
    
    // Trace the twister
    if (closest_dist <= 0.0) {
        for (int it = 0 ; it < ITERATIONS ; it++) {
            float s1 = DIST - hmax + float(it) * STEPSIZE;
            float dist1 = tv(r, s1, d, c, k);
            if (dist1 <= 0.0) {
                float s0 = s1-STEPSIZE;
                for (int i = 0 ; i < 8 ; i++) {
                    float hs = (s0 + s1) * 0.5;
                    float hdist = tv(r, hs, d, c, k);
                    if (hdist > 0.0) {
                        s0 = hs;
                        dist0 = hdist;
                    } else {
                        s1 = hs;
                        dist1 = hdist;
                    }
                }
                depth = (s0 + s1) * 0.5;
                break;
            }
            dist0 = dist1;
        }
    }

   	// Compute normal
    vec3 pos = vec3(xy,depth*0.01);
    vec3 n = normalize(cross(dFdx(pos),dFdy(pos)));

    // Move light ball
    float revtime = time*0.8;
    vec3 ball = vec3(0.25*sin(revtime),0.05*sin(time*0.3),0.25*-cos(revtime));
	float bdist = DIST*0.01-ball.z;
    vec2 ballpos = ball.xy / bdist;
	float b = 0.0003 / (bdist * dot(xyr - ballpos, xyr - ballpos));

    vec3 color;
    if (depth == FAR) {
        // Background
        color = (vec3(0,0.0,0.1) + floor(fract((c-xyr.x*xyr.x*xyr.y)*0.5)*2.0)*vec3(0.1,0.1,0.1)) * d*d*1.5;
		float f = 0.3 + 0.28*sin(time*1.3);

        // Glow
        vec3 glowcol = vec3(0.2,0.0,0.0) + f * vec3(0.3,0.7,0.7);
        float ms = max(0.0, -sin(time*0.2));
        float glow = exp(-closest_dist*0.2)*(0.7-0.3*sin(time*SPEED*M_PI))*ms;
        color += glowcol*glow;

        // Draw ball if behind
        if (ball.z < 0.0) color = min(color,vec3(1)) * (1.0 - b) + b;
    } else {
		// Twister
        color = vec3(0);
        color += light(n, vec3(1,-1,1), vec3(1.2,0.6,0.15));
        color += light(n, vec3(-2,1,1), vec3(0,0.05,0.1));
		vec3 ballvec = ball-vec3(xyr,depth*0.01);
        color += light(n, ballvec, vec3(0.5,0.7,0.9))*max(0.0,ball.z)*5.0;
    }
    color = min(color,vec3(1));
	
    // Draw ball if in front
    if (ball.z >= 0.0) color = mix(color, vec3(1), b);

    gl_FragColor = vec4(sqrt(color),1);
}

